<?php
 session_start();
 require_once('../connect.php');
 require_once('sql_required.php');

 
 if (!isset($_SESSION['username'])) { ?>
  <script language="javascript">
    window.location.href = '../index.php';
  </script>
<?php }


// Fetch active users
$sql_active = "SELECT * FROM tbl_user_account WHERE line_status = 1";
$result_active = mysqli_query($conn, $sql_active);

// Fetch inactive users
$sql_inactive = "SELECT * FROM tbl_user_account WHERE line_status = 0";
$result_inactive = mysqli_query($conn, $sql_inactive);
?>
 
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Active & Inactive Users</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2 class="text-center">User Account Status</h2>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs" id="userTabs">
        <li class="nav-item">
            <a class="nav-link active" data-bs-toggle="tab" href="#activeTab">Active Lines</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#inactiveTab">Inactive Lines</a>
        </li>
    </ul>

    <!-- Tabs Content -->
    <div class="tab-content mt-3">
        
        <!-- Active Users Tab -->
        <div id="activeTab" class="tab-pane fade show active">
            <h4 class="text-success">Active Lines</h4>
            <table  id = "active" class="table table-bordered table-striped">
                <thead class="table-success">
                    <tr>
                        
                        <th>Accnt #</th>
                        <th>Name</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($result_active) > 0): ?>
                        <?php while ($row = mysqli_fetch_assoc($result_active)) : ?>
                            <tr>
                               
                                <td><?php echo $row['unique_id']; ?></td>
                                <td><?php echo $row['acct_holder']; ?></td>
                                <td class="text-success">Active</td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="3" class="text-center text-muted">No active users found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Inactive Users Tab -->
        <div id="inactiveTab" class="tab-pane fade">
            <h4 class="text-danger">Inactive Lines</h4>
            <table id = "inactive" class="table table-bordered table-striped">
                <thead class="table-danger">
                    <tr>
                    <th>Accnt #</th>
                    <th>Name</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($result_inactive) > 0): ?>
                        <?php while ($row = mysqli_fetch_assoc($result_inactive)) : ?>
                            <tr>
                            <td><?php echo $row['unique_id']; ?></td>
                            <td><?php echo $row['acct_holder']; ?></td>
                                <td class="text-danger">Inactive</td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="3" class="text-center text-muted">No inactive users found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>

<?php
// Close database connection
mysqli_close($conn);
?>




<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>


  
  
<script src="https://cdn.datatables.net/buttons/2.3.2/js/dataTables.buttons.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.bootstrap4.min.js"></script>
 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.colVis.min.js"></script>

 
<script>

    
$(document).ready(function() {
    $('#active').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false, // Set to false for better rendering performance
        "responsive": true,
        "stateSave": true,
        "dom": 'Bfrtip',
        "buttons": [
           // 'excel', 'pdf', 'print'
        ],
    });

    $('#inactive').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false, // Set to false for better rendering performance
        "responsive": true,
        "stateSave": true,
        "dom": 'Bfrtip',
        "buttons": [
           // 'excel', 'pdf', 'print'
        ],
    });
});
</script>