<?php
 session_start();
 require_once('../connect.php');
 require_once('sql_required.php');

 $datetoday = date('Y-m-d'); 

if (!isset($_SESSION['unique_id'])) { ?>
    <script language="javascript">
      window.location.href = '../index.php';
    </script>
<?php } ?>  
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Account</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
  <link rel="icon" href="images/logo.png" type="image/png" sizes="16x16">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.css">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="css/style1.css">
  <link rel="stylesheet" type="text/css" href="css/skeleton_loading.css">
<style type="text/css">
  .content-wrapper {
    background: #151e27!important;
  }
  .main-footer {
    background: #151e27!important;
    border-top: 1px solid #dee2e6;
    color: #869099;
    padding: 1rem;
  }
  .list-group-item {
    background: #1d2532!important;
    color: #fff!important;
  }
  .account-href {
    cursor: pointer; 
    display: block;
    color: #fff;
  }
  .account-href:hover {
    color: #fff;
  }
  @media(max-width:800px) {
    .modal-content {
      position: fixed; bottom: 40%; width: 96%; left: 7;
    }
    .modal-dialog {
      margin: 0!important; padding: 0!important;
    }
  }
  .btn {
    border-radius: 10px;
  }
  .card {
    border-radius: 20px; 
    box-shadow: none; 
    background: #27313d;
    color: grey;
  }
  .card:hover {
    border: 1px solid #fff;
    color: #fff!important;
  }
  .img-circle {
    border-color: grey;
  }
</style>
</head>
<body class="hold-transition sidebar-mini layout-footer-fixed layout-fixed" style="background: #151e27;">
<div id="preloader" class="loading" style="display: none"></div>
<div class="wrapper">
  <nav class="main-header navbar navbar-expand navbar-white" style="background: #151e27; border-bottom: 0; box-shadow: none!important;">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link text-white"><span style="font-size: 20px; font-weight: bolder; line-height: 20px">Account</span></a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
    </ul>
  </nav>

<?php include ("navbar.php")?>
<div class="content-wrapper">

  <section class="content p-0">
    <div class="container-fluid pt-0 pb-0 pl-3 pr-3">
        <div align="right" class="pt-2">
            <a href="edit_profile.php?<?php echo generate_string($permitted_chars, 100) ?>" class="withanimation" style="color: #ffd700;">Edit Profile</a>
        </div>

            <div class="pt-0 pb-2 row">
              <div class="col-4 col-md-1">
                <img class="profile-user-img img-fluid img-circle" src="dist/img/avatar5.png" alt="User profile picture">
              </div>
              <div class="col-8 col-md-11">
                <p class="pt-1 text-white" style="font-size: 20px; margin-bottom: 0px;"><b><?php echo $firstname.' '.$lastname; ?></b></p>
                <span><small style="font-weight: 800" class="text-muted"><span style="font-weight: normal;">Your account ID:</span> <?php echo $unique_id; ?></small></span><br>
              </div>
            </div>
    </div>
  </section>

  <section class="content menu-main">
    <div class="container-fluid">
          <div class="row">

            <div class="col-4 mt-3">
                
                <a href="#">  
                <div class="card">
                  <div class="card-body pb-0">
                    <center>
                      <i class="fas fa-circle" style="font-size: 30px;"></i>
                      <p class="pt-2"><small>Tab</small></p>
                    </center>
                  </div>
                </div>
                </a>

            </div>

            <div class="col-4 mt-3">
                
                <a href="#">  
                <div class="card">
                  <div class="card-body pb-0">
                    <center>
                      <i class="fas fa-circle" style="font-size: 30px;"></i>
                      <p class="pt-2"><small>Tab</small></p>
                    </center>
                  </div>
                </div>
                </a>

            </div>

            <div class="col-4 mt-3">
                
            <a href="#">
            <div class="card">
              <div class="card-body pb-0">
                <center>
                  <i class="fas fa-circle" style="font-size: 30px;"></i>
                  <p class="pt-2"><small>Tab</small></p>
                </center>
              </div>
            </div>
            </a>

        </div>
      </div>

    </div>
  </section>
<ul class="list-group list-group-unbordered mb-3">
    <li class="list-group-item pl-2 pr-3 pt-3 pb-3">
      <a href="#" class="account-href withanimation"><span class="badge badge-dark pb-2 pt-2" style="border-radius: 50%; padding-right: 8px;  padding-left: 8px;"><i class="fas fa-list" style="color: #fff"></i></span>&nbsp;&nbsp;Link <span class="float-right"><i class="fas fa-angle-right" style="font-size: 25px; color: grey"></i></span></a>
    </li>
    <li class="list-group-item pl-2 pr-3 pt-3 pb-3">
      <a href="#" class="account-href" data-toggle="modal" data-target="#alert_list_image"><span class="badge badge-primary pb-2 pt-2" style="border-radius: 50%; padding-right: 11px;  padding-left: 11px;"><i class="fas fa-info" style="color: #fff"></i></span>&nbsp;&nbsp;Terms, Privacy & Policy <span class="float-right"><i class="fas fa-angle-right" style="font-size: 25px; color: grey"></i></span></a>
    </li>
    <li class="list-group-item pl-2 pr-3 pt-3 pb-3">
      <a href="#" class="account-href" data-toggle="modal" data-target="#alert_list_image"><span class="badge badge-warning p-2" style="border-radius: 50%"><i class="fas fa-phone" style="color: #fff"></i></span>&nbsp;&nbsp;Help & Support <span class="float-right"><i class="fas fa-angle-right" style="font-size: 25px; color: grey"></i></span></a>
    </li>
    <li class="list-group-item pl-2 pr-2 pt-3 pb-3">
      <a type="button" data-toggle="modal" data-target="#logout" class="account-href"><span class="badge badge-dark p-2" style="border-radius: 50%"><i class="fas fa-lock"></i></span>&nbsp;&nbsp;Logout</a>
    </li>
</ul>

<div class="modal" id="logout">
  <div class="modal-dialog">
    <div class="modal-content" style="background-color: #151e27!important;">
      <div class="modal-header pb-0" style="border: 0px;">
        <h5 class="modal-title text-white" style="font-weight: bold;">Logout</h5>
      </div>
      <div class="modal-body pt-0 pb-0">
        <p class="text-muted">Are you sure you want to logout ?</p>
      </div>
      <div class="modal-footer pr-0 pl-0 pb-2 pt-0" style="display: block; border: 0px">
        <div class="row">
          <div class="col-6">
            <button type="button" class="btn btn-default btn-lg btn-block" style="background: transparent; color: #fff;" data-dismiss="modal">Cancel</button>
          </div>
          <div class="col-6">
            <a href="logout.php" class="btn btn-warning btn-lg btn-block withanimation" style="background: #FFD700; border-color: #ffd700;">Logout</a>
          </div>
        </div>
        
      </div>
    </div>
  </div>
</div> <!-- logout -->

</div>
</div>

<script src="dist/js/adminlte.min.js"></script>
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="plugins/jquery-validation/additional-methods.min.js"></script>
<script src="dist/js/pages/dashboard.js"></script>
<script src="plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<script type="text/javascript">
$(function () {
  $(".withanimation").click(function(e) {
      e.preventDefault();
      $(".loading").show();
      var url=$(this).attr("href");
      setTimeout(function() {
          window.location=url;
      }, 500);
  });
});
</script>
</body>
</html>
