<section class="content-header bg-newprimary text-light py-3">
  <div class="container-fluid">

    <!-- Header Row -->
    <div class="d-flex justify-content-between align-items-center flex-wrap">
      <div>
        <h5 class="mb-0">
          ₱<?= number_format($todaypayreceived ?? 0, 2); ?>
          <small class="text-light">Total Collection</small>
        </h5>
      </div>
      <button class="btn btn-sm btn-light" data-toggle="collapse" data-target="#toggleDetails" aria-expanded="false" aria-controls="toggleDetails" id="toggleButton">
        <i class="fas fa-chevron-down" id="toggleIcon"></i> Show Details
      </button>
    </div>

    <!-- Collapsible Section -->
    <div class="collapse mt-3" id="toggleDetails">
      <?php
        $sql_checkplacement = "SELECT * FROM tbl_reading_sched WHERE status = 1";
        $result_countplacement = mysqli_query($conn, $sql_checkplacement);
        $row_date = mysqli_fetch_assoc($result_countplacement);
        $c_readingdate = $row_date["reading_date"];
        $c_due_date = $row_date["due_date"];
        $c_disconnection_date = $row_date["disconnection_date"];
      ?>

      <!-- Reading Dates -->
      <div class="bg-white text-dark rounded p-2 mb-2 text-center small shadow-sm">
        <b>Reading:</b> <?= $c_readingdate ?> &nbsp;|&nbsp;
        <b>Due:</b> <?= $c_due_date ?> &nbsp;|&nbsp;
        <b>Disconnection:</b> <?= $c_disconnection_date ?>
      </div>

      <!-- Active & Inactive Lines -->
      <?php
        $sql_totalActive = "SELECT COUNT(*) AS activelines FROM tbl_user_account WHERE branch = 'LAGUNA' AND line_status = 1";
        $result_active = mysqli_query($conn, $sql_totalActive);
        $activelines = $result_active ? mysqli_fetch_assoc($result_active)['activelines'] : 0;

        $sql_totalInactive = "SELECT COUNT(*) AS inactivelines FROM tbl_user_account WHERE branch = 'LAGUNA' AND line_status = 0";
        $result_inactive = mysqli_query($conn, $sql_totalInactive);
        $inactivelines = $result_inactive ? mysqli_fetch_assoc($result_inactive)['inactivelines'] : 0;
      ?>
      <div class="bg-white text-dark rounded p-2 mb-2 shadow-sm">
        <div class="d-flex justify-content-between small">
          <span><b class="text-success">Active:</b></span>
          <span><?= $activelines ?></span>
        </div>
        <div class="d-flex justify-content-between small">
          <span><b class="text-danger">Inactive:</b></span>
          <span><?= $inactivelines ?></span>
        </div>
      </div>

      <!-- Unsettled Payments Link -->
      <div class="text-center">
        <a href="withbalance_history.php" class="badge badge-warning text-dark px-3 py-2">View Unsettled Payments</a>
      </div>
    </div>
  </div>
</section>

<!-- Script: Toggle Arrow & Text -->
<script>
  document.getElementById('toggleButton').addEventListener('click', function () {
    const icon = document.getElementById('toggleIcon');
    icon.classList.toggle('fa-chevron-down');
    icon.classList.toggle('fa-chevron-up');
    this.innerHTML = icon.classList.contains('fa-chevron-down')
      ? '<i class="fas fa-chevron-down" id="toggleIcon"></i> Show Details'
      : '<i class="fas fa-chevron-up" id="toggleIcon"></i> Hide Details';
  });
</script>

<style>
  .bg-newprimary {
    background: #eb00c9 !important;
  }
  @media (max-width: 576px) {
    .content-header h5 {
      font-size: 1rem;
    }
  }
</style>
