<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once('../connect.php');
    $accountNo = $_POST['accountNo'];
    $newReading = $_POST['newReading'];

    // Update the pres_reading and new_meter fields in tbl_user_account
    $query = "UPDATE tbl_user_account SET pres_reading = ?, new_meter = 1 WHERE unique_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ds", $newReading, $accountNo);

    $response = [];

    if ($stmt->execute()) {
        $response['success'] = true;
        $response['message'] = 'Meter reading updated successfully!';
    } else {
        $response['success'] = false;
        $response['message'] = 'Failed to update meter reading.';
    }

    $stmt->close();
    $conn->close();

    // Set the correct content type for JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
