<!-- Include SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Add Payment TAB HTML -->
<div id="addPaymentModal" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="user_form_billspayment">
        <div class="modal-header">
          <h4 class="modal-title">Add Water Bills Payment</h4>
          <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-sm-3">
              <label for="id_u">Account#: </label>
              <input type="text" id="id_u" name="id" class="form-control" readonly>
            </div>
            <div class="col-sm-9">
              <label for="txt_acct_holder">Account Holder: </label>
              <input type="text" id="txt_acct_holder" name="acctholder" class="form-control" readonly>
            </div>
          </div>
          <br>
          <div class="card card-primary card-outline card-tabs">
            <div class="card-header p-0 pt-1 border-bottom-0">
              <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="custom-tabs-three-home-tab" data-toggle="pill" href="#custom-tabs-three-waterbill" role="tab" aria-controls="custom-tabs-three-home" aria-selected="true">Water Bill</a>
                </li>
               
              </ul>
            </div>
            <div class="card-body">
              <div class="tab-content" id="custom-tabs-three-tabContent">
                <!-- Water Bill Tab -->
                <div class="tab-pane fade show active" id="custom-tabs-three-waterbill" role="tabpanel" aria-labelledby="custom-tabs-three-home-tab">
                  <center style="background: #2f2f2f; color: #fff; font-size: 20px;">
                    <b style="color: #e90707;">PAY WATER BILL</b>
                  </center>
                  <hr>
                  <div class="form-group">
                    <label for="select_readingdate">Select Reading Date: </label>
                    <select class="form-control" name="select_readingdate" aria-label="Default select example">
                      <option value="" disabled>Select Date</option>
                      <?php
                        $result = mysqli_query($conn, "SELECT * FROM tbl_reading_sched ORDER BY status DESC");
                        while ($row = mysqli_fetch_array($result)) {
                          echo "<option value='{$row['reading_date']}'>{$row['reading_date']}</option>";
                        }
                      ?>
                    </select>
                  </div>
                  <div class="form-group">
                    <label for="payment_date">Payment Collection Date:</label>
                    <input  type="date" value="<?php echo $thedatetoday; ?>" class="form-control" id="payment_date" name="payment_date" <?php if ($_SESSION['username'] != 'MainAdmin') echo 'readonly'; ?>>
                  </div>
                  <div class="form-group" style="background: #f80000; padding: 10px; color: #fff;">
                    <label>Unpaid Balance:</label>
                    
                    <input type="text" id="wbbalance" name="wbbalance" class="form-control" style="font-size: 18px; color: blue; font-weight: bold;" readonly>
                  </div>
                  <div class="form-group">
                    <label for="payment_ref">Payment Reference Number:</label>
                    <input type="text" id="payment_ref" name="payment_ref" class="form-control" readonly>
                  </div>
                  <div class="form-group">
                    <label>Enter Amount:</label>
                    <input type="text" name="waterbill_amount" min="0" placeholder="0" class="form-control" style="font-size: 40px; color: #ff0505; padding: 10px; font-weight: bold; text-align: center;" required autofocus>
                  </div>
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="modeofpay" id="inlineRadio1" value="CASH" checked>
                    <label class="form-check-label" for="inlineRadio1"><b>CASH</b></label>
                  </div>
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="modeofpay" id="inlineRadio2" value="GCASH">
                    <label class="form-check-label" for="inlineRadio2"><b>G-CASH</b></label>
                  </div>
                  <div class="modal-footer">
                  
                    <button type="button" class="btn btn-success btn-radius btn-block btn-multi text-white" id="btn-addbillspayment">Submit Payment</button>
                  </div>
                  <center>
                    <a href="transactionhistory.php?mid=" onclick="this.href = this.href + document.getElementById('id_u').value;">[View Payment History]</a>
                  </center>
                </div>
                <!-- Meter Device Tab -->
             
              

              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    // Function to generate a unique payment reference number
    function generatePaymentReference() {
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        let refNumberbillspay = '';
        for (let i = 0; i < 10; i++) {
          refNumberbillspay += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        return refNumberbillspay;
    }

    // Display the generated reference number before the amount field
    document.addEventListener('DOMContentLoaded', function() {
        const refNumberbillspay = generatePaymentReference();
        document.getElementById('payment_ref').value = refNumberbillspay;
    });
</script>
<script>
    $(document).ready(function () {
        $('#btn-addbillspayment').on('click', function () {
            var formData = $('#user_form_billspayment').serialize();

            $.ajax({
                url: 'submit_readingpayment.php',
                type: 'POST',
                data: formData,
                dataType: 'json',
                beforeSend: function () {
                    Swal.fire({
                        title: 'Processing...',
                        text: 'Please wait...',
                        allowOutsideClick: false,
                        didOpen: () => Swal.showLoading()
                    });
                },
                success: function (response) {
                    Swal.close(); // Close loading modal

                    console.log("Response received:", response); // Debugging

                    Swal.fire({
                        title: response.statusCode === 200 ? 'Success!' : 'Error!',
                        text: response.message,
                        icon: response.statusCode === 200 ? 'success' : 'error',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        if (response.statusCode === 200) {
                            window.location.href = 'printlogs.php';
                        }
                    });
                },
                error: function (xhr, status, error) {
                    Swal.close(); // Close loading modal

                    console.error("AJAX Error:", xhr.responseText);

                    Swal.fire({
                        title: 'Error!',
                        text: 'Something went wrong! Check the console.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });
    });
</script>



 

 